<!DOCTYPE html>
<html class="no-js" lang="<?php echo $activeLang->description; ?>">

<head>
    <?php $this->load->view("includes/head"); ?>
    <?php $this->load->view("includes/include_style"); ?>
    <?php $this->load->view("dashboard/page_style"); ?>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/scroll-animation.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/hole.css">
</head>

<body data-mobile-nav-style="classic">
<header>
    <nav class="navbar navbar-expand-lg header-transparent bg-transparent header-reverse" data-header-hover="light">
        <div class="container-fluid">
            <?php $this->load->view("includes/logo"); ?>
            <?php $this->load->view("includes/menu"); ?>
            <?php $this->load->view("includes/menu_right"); ?>
        </div>
    </nav>
</header>

<section class="section-dark p-0 bg-dark-gray">
    <?php $this->load->view("dashboard/slider"); ?>
</section>

<section>
    <div class="container">
        <?php $this->load->view("dashboard/start_section"); ?>
    </div>
</section>

<section class="bg-primary">
    <div class="container">
        <?php $this->load->view("dashboard/turnkey"); ?>

    </div>
</section>

<section class="bg-very-light-gray overlap-height position-relative background-position-center background-repeat" style="background-image: url('<?php echo base_url(); ?>assets/images/vertical-center-line-bg-dark.svg')">
    <div class="container overlap-gap-section">
        <?php $this->load->view("dashboard/industry"); ?>
    </div>
</section>

<section class="pb-0 border-bottom">
    <div class="container-fluid">
        <div class="row d-flex end-0">
            <div class="col-md-6 align-bottom">
                <img src="<?php echo base_url(); ?>assets/images/home/count.svg" alt="">
            </div>
            <div class="col-md-6 align-bottom">
                <img src="<?php echo base_url(); ?>assets/images/home/man-model.png" alt="">
            </div>
        </div>
    </div>
</section>

<section class="pb-0">
    <div class="container">
        <?php $this->load->view("dashboard/mechanic"); ?>
    </div>
</section>

<section class="pb-0">
    <div class="container">
        <?php $this->load->view("dashboard/experience"); ?>
    </div>
</section>

<section class="bg-very-light-gray" id="agents">
    <div class="container">
    <?php $this->load->view("dashboard/team"); ?>
    </div>
</section>

<section class="scroll-animation-section">
    <?php $this->load->view("dashboard/scroll"); ?>
</section>

<section class="p-0">
    <div class="container-fluid p-0">
        <?php $this->load->view("dashboard/renewable"); ?>
    </div>
</section>

<section class="position-relative overflow-hidden">
    <div class="container">
        <?php $this->load->view("dashboard/future"); ?>
    </div>
</section>

<section class="bg-very-light-gray">
    <div class="container-fluid">
        <?php $this->load->view("dashboard/gallery"); ?>
    </div>
</section>

<section>
    <div class="container">
        <?php $this->load->view("dashboard/map"); ?>
    </div>
</section>

<section class="pt-0">
    <div class="container">
        <?php $this->load->view("dashboard/form"); ?>
    </div>
    <div class="position-absolute bottom-minus-40px lg-bottom-minus-20px text-center w-100 fs-250 xxl-fs-200 xl-fs-180 lg-fs-140 d-none d-md-block text-gradient-light-green-white z-index-minus-2 ls-minus-8px fw-700"
         data-anime='{ "translateY": [30, 0], "opacity": [0,1], "duration": 1200, "delay": 0, "staggervalue": 150, "easing": "easeOutQuad" }'>
        Green energy
    </div>
</section>

<section class="bg-gradient-green-transparent">
    <div class="container">
        <?php $this->load->view("includes/blog"); ?>
    </div>
</section>

<footer class="bg-dark-gray pb-30px">
    <div class="container">
        <?php $this->load->view("includes/footer"); ?>
    </div>
</footer>


<?php $this->load->view("includes/include_script"); ?>
<?php $this->load->view("dashboard/page_script"); ?>
<script type="module" src="<?php echo base_url(); ?>assets/js/scroll-animation.js"></script>
<script type="module" src="<?php echo base_url(); ?>assets/js/hole.js"></script>
</body>

</html>