<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Service extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();

	}

	function _remap($parameter){

		$this->index($parameter);
	}

	public function index()
	{
		$viewData = new stdClass();

		$this->load->model("City_model");
		$citys                          = $this->City_model->get_all(array());
		$this->load->model("Lang_model");
		$langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

		$getLang 	= getLang();
		$lang_id = $this->session->userdata("lang_id");
		if(empty($lang_id)){
			$lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
			if (isset($lang) && $lang){
				$this->session->set_userdata('lang_id',$lang->id);
			}else{
				$this->session->set_userdata('lang_id',2);
			}

		};
		$lang_id 		= $this->session->userdata("lang_id");
		$activeLang		= $this->Lang_model->get(array("id" => $lang_id));

		//JOIN OLAYI
		$this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
		$this->db->from('contact c');
		$this->db->join('city ct', 'c.city_id = ct.id', 'left');
		$this->db->join('county cn', 'c.county_id = cn.id', 'left');
		$this->db->order_by("c.id", "ASC");
		$this->db->where("c.lang_id", $lang_id);
		$contact = $this->db->get()->row();

		$this->load->model("Word_To_Lang_model");
		$words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");

		$this->db->select('s.id, s.img_url, s.img_url_banner, s.title_'.$activeLang->description.' as title, 
		s.description_'.$activeLang->description.' as description, s.short_title_'.$activeLang->description.' as short_title');
		$this->db->select('s.seo_des_'.$activeLang->description.' as seo_des, s.seo_title_'.$activeLang->description.' as seo_title, s.icon');
		$this->db->from('service s');
		$this->db->order_by("s.rank", "ASC");
		$this->db->where("s.isActive", 1);
		$services = $this->db->get()->result();

        $this->db->select('i.id, i.img_url, i.title_'.$activeLang->description.' as title, i.description_'.$activeLang->description.' as description, i.short_title_'.$activeLang->description.' as short_title');
        $this->db->select('i.seo_des_'.$activeLang->description.' as seo_des, i.seo_title_'.$activeLang->description.' as seo_title, i.icon');
        $this->db->from('industry i');
        $this->db->order_by("i.rank", "ASC");
        $this->db->where("i.isActive", 1);
        $industrys = $this->db->get()->result();

        $this->db->select('p.id, p.title_'.$activeLang->description.' as title, p.location_'.$activeLang->description.' as url');
        $this->db->from('value p');
        $this->db->where("p.isActive", 1);
        $this->db->order_by("p.id", "ASC");
        $values = $this->db->get()->result();

		$viewData->contact              = $contact;
		$viewData->citys                = $citys;
		$viewData->langs            	= $langs;
		$viewData->lang_id          	= $lang_id;
		$viewData->words            	= $words;
		$viewData->industrys 			= $industrys;
		$viewData->services 			= $services;
		$viewData->values 			    = $values;
		$viewData->activeLang 			= $activeLang;
		$viewData->activePage           = "services";

		$viewData->seo_title            = $contact->seo_title;
		$viewData->seo_key              = $contact->seo_key;
		$viewData->seo_des              = $contact->seo_des;

		$parameter 	= $this->uri->segment(2);

		if(isset($parameter) && $parameter){

			$this->db->select('i.id, i.img_url, i.img_url_banner, i.title_'.$activeLang->description.' as title, i.description_'.$activeLang->description.' as description, i.short_title_'.$activeLang->description.' as short_title');
			$this->db->select('i.seo_des_'.$activeLang->description.' as seo_des, i.seo_title_'.$activeLang->description.' as seo_title, i.seo_key_'.$activeLang->description.' as seo_key, i.icon');
			$this->db->from('service i');
			$this->db->order_by("i.rank", "ASC");
			$this->db->where("i.isActive", 1);
			$this->db->where("i.short_title_".$activeLang->description, $parameter);
            $service = $this->db->get()->row();

            $this->db->select('ip.id, ip.img_url, ip.title_'.$activeLang->description.' as title, ip.description_'.$activeLang->description.' as description');
            $this->db->from('service_photo ip');
            $this->db->where("ip.isActive", 1);
            $this->db->where("ip.service_id", $service->id);
            $service_photos = $this->db->get()->result();

            $this->db->select('iv.id, iv.img_url, iv.video_url, iv.title_'.$activeLang->description.' as title, iv.description_'.$activeLang->description.' as description');
            $this->db->from('service_video iv');
            $this->db->where("iv.isActive", 1);
            $this->db->where("iv.service_id", $service->id);
            $service_video = $this->db->get()->row();

            $this->db->select('wc.id, wc.img_url, wc.title_'.$activeLang->description.' as title, wc.description_'.$activeLang->description.' as description');
            $this->db->from('why_choose wc');
            $this->db->where("wc.isActive", 1);
            $whys = $this->db->get()->result();

			$viewData->service          = $service;
			$viewData->service_photos   = $service_photos;
			$viewData->service_video    = $service_video;
			$viewData->whys 			= $whys;

			$this->load->view('pages/service/detail', $viewData);
		}else{
			$this->load->view('pages/service/index', $viewData);
		}

	}


}
