<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Project extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();

	}

	function _remap($parameter){

		$this->index($parameter);
	}

	public function index()
	{
		$viewData = new stdClass();

		$this->load->model("City_model");
		$citys                          = $this->City_model->get_all(array());
		$this->load->model("Lang_model");
		$langs                      	= $this->Lang_model->get_all(array("isActive" => 1,"isDeleted" => 0), "","id ASC");

		$getLang 	= getLang();
		$lang_id = $this->session->userdata("lang_id");
		if(empty($lang_id)){
			$lang		= $this->Lang_model->get(array("isActive" => 1,"isDeleted" => 0, "description" => $getLang), "","id ASC");
			if (isset($lang) && $lang){
				$this->session->set_userdata('lang_id',$lang->id);
			}else{
				$this->session->set_userdata('lang_id', 2);
			}

		};
		$lang_id 		= $this->session->userdata("lang_id");
		$activeLang		= $this->Lang_model->get(array("id" => $lang_id));

		//JOIN OLAYI
		$this->db->select('c.*, ct.title as cTitle, cn.title as cnTitle');
		$this->db->from('contact c');
		$this->db->join('city ct', 'c.city_id = ct.id', 'left');
		$this->db->join('county cn', 'c.county_id = cn.id', 'left');
		$this->db->order_by("c.id", "ASC");
		$this->db->where("c.id", $lang_id);
		$contact = $this->db->get()->row();

		$this->load->model("Word_To_Lang_model");
		$this->load->model("Gallery_model");
		$words                      	= $this->Word_To_Lang_model->get_all(array("lang_id" => $lang_id), "", "id ASC");
		$gallerys                      	= $this->Gallery_model->get_all(array(), "", "id ASC");

		$this->db->select('au.id, au.img_url, au.title_'.$activeLang->description.' as title, au.short_title_'.$activeLang->description.' as short_title, au.description_'.$activeLang->description.' as description');
		$this->db->from('about_us au');
		$this->db->where("au.isActive", 1);
		$this->db->order_by("au.id", "ASC");
		$about_us = $this->db->get()->result();

		$this->db->select('s.id, s.img_url, s.title_'.$activeLang->description.' as title, s.description_'.$activeLang->description.' as description, s.short_title_'.$activeLang->description.' as short_title');
		$this->db->select('s.seo_des_'.$activeLang->description.' as seo_des, s.seo_title_'.$activeLang->description.' as seo_title');
		$this->db->from('service s');
		$this->db->order_by("s.rank", "ASC");
		$this->db->where("s.isActive", 1);
		$services = $this->db->get()->result();

		$this->db->select('p.id, p.img_url, p.location_'.$activeLang->description.' as location,
		, p.title_'.$activeLang->description.' as title, p.short_title_'.$activeLang->description.' as short_title, p.description_'.$activeLang->description.' as description');
		$this->db->from('project p');
		$this->db->where("p.isActive", 1);
		$this->db->order_by("p.id", "ASC");
		$projects 	= $this->db->get()->result();


		$viewData->contact              = $contact;
		$viewData->citys                = $citys;
		$viewData->langs            	= $langs;
		$viewData->lang_id          	= $lang_id;
		$viewData->words            	= $words;
		$viewData->gallerys            	= $gallerys;
		$viewData->services 			= $services;
		$viewData->about_us 			= $about_us;
		$viewData->projects 			= $projects;
		$viewData->activeLang 			= $activeLang;
		$viewData->activePage           = "about_us";

		$parameter = $this->uri->segment(2);

		if (isset($parameter) && $parameter){
			$this->db->select('p.id, p.img_url, p.logo_url, p.location_'.$activeLang->description.' as location, p.title_'.$activeLang->description.' as title, p.short_title_'.$activeLang->description.' as short_title, p.description_'.$activeLang->description.' as description');
			$this->db->from('project p');
			$this->db->where("p.isActive", 1);
			$this->db->where("p.short_title_".$activeLang->description, $parameter);
			$this->db->order_by("p.id", "ASC");
			$project 	= $this->db->get()->row();

			if ($project){

				$this->db->select('pp.*');
				$this->db->from('project_photo pp');
				$this->db->where("pp.isActive", 1);
				$this->db->where("pp.project_id", $project->id);
				$this->db->order_by("pp.id", "RANDOM");
				$project_gallerys = $this->db->get()->result();

				$viewData->project            	= $project;
				$viewData->project_gallerys		= $project_gallerys;
				$viewData->seo_title            = $contact->seo_title;
				$viewData->seo_key              = $contact->seo_key;
				$viewData->seo_des              = $contact->seo_des;

				$this->load->view('pages/project/detail', $viewData);

			}else{

				$viewData->seo_title            = $contact->seo_title;
				$viewData->seo_key              = $contact->seo_key;
				$viewData->seo_des              = $contact->seo_des;

				$this->load->view('pages/project/index', $viewData);

			}

		}else{

			$viewData->seo_title            = $contact->seo_title;
			$viewData->seo_key              = $contact->seo_key;
			$viewData->seo_des              = $contact->seo_des;

			$this->load->view('pages/project/index', $viewData);

		}


	}


}
